const express = require("express");
const cors = require("cors");
const mysql = require("mysql")
  const bodyParser = require("body-parser");
 const cookieParser = require("cookie-parser");
 const session = require("express-session");
 const jwt = require('jsonwebtoken')
const bcrypt = require("bcrypt");
const router = express.Router();
const multer  = require('multer')
const path  = require('path')
const salt = 10;
const app = express();
const dotenv = require('dotenv');
dotenv.config();
app.use(express.json());
app.use(bodyParser.json());
 app.use(cors(
    {
    origin: ["http://localhost:3000"],
    methods: ["POST", "GET", "PUT", "DELETE"],
    credentials: true
  
   }));
   app.use(session({
    secret: 'secret',
    resave: false,
    saveUninitialized: false,
    cookie: {
      secure: false,
      maxAge: 1000 * 60 * 60 * 24
    }
  }))


  
app.use(cookieParser());


const storage = multer.diskStorage({
  destination : (req, file, cb)=> {
    cb(null, 'public/images')
  },
  filename: (req, file, cb)=>{
    cb(null, file.fieldname + "_" + Date.now()+ path.extname(file.originalname));
  }
})

const upload =multer({
    storage :storage
})
 const db =mysql.createConnection({
host: process.env.HOST,
user : process.env.USER,
password : process.env.PASSWORD,
database : process.env.DATABASE
})

// const verifyUser =(req, res, next)=>{
// const token  = req.cookies.token;
// if(!token){
//   return res.json({Error: "You are not authenticated"});
// }
// else{
//   jwt.verify(token, "jwt-secret-key" , (err, decoded)=>{ 
//   if(err){
//     return res.json({Error: "token not  okay"});
//   }
//   else{
//     req.username = decoded.username;
//     next();
//   }})
// }
// }


app.post("/uploadimg", upload.single('image') ,(req, res) =>{
console.log(req.file)
})
app.get("/", (req, res) => {
 if(req.session.username){
  return res.json({valid:true, username: req.session.username, schoolcode: req.session.schoolcode});
  
 }
 else{
  return res.json({valid:false});
 }
});

// router.get('/', function(req, res, next) {
//   res.render('index', { title: 'Express', session : req.session });
// });

// router.get('/logout', function(request, response, next){

//   request.session.destroy();

//   response.redirect("/");

// });

app.delete('/logout', (req, res) => { 
  req.session.destroy(err => { 
    if (err) { 
      return res.status(500).send('Could not log out.'); 
    } 
    res.send('Logout successful!'); 
  }); 
}); 

app.delete('/logoutadmin', (req, res) => { 
  req.session.destroy(err => { 
    if (err) { 
      return res.status(500).send('Could not log out.'); 
    } 
    res.send('Logout successful!'); 
  }); 
}); 




// module.exports = router;


app.get("/studentsdata", (req, res) => {
    db.query("SELECT * FROM student_details", (err, result) => {
      if (err) {
        console.log(err);
      } else {
        res.send(result);
      }
    });
  });


  // app.get("/fetchdatareg/", (req, res) => {
  //   db.query("SELECT * FROM student_details", (err, result) => {
  //     if (err) {
  //       console.log(err);
  //     } else {
  //       res.send(result);
  //     }
  //   });
  // });

  app.get("/fetchdatareg/", (req, res) => {
    // const schoolcodedata = req.params.schoolcodedata;
    const sql = "SELECT * FROM student_details ";
    db.query(sql, (err, result) => {
      if (err) res.send({ message: "Server error" });
     res.send(result);
    });
  });


app.get("/get_student/:id", (req, res) => {
    const id = req.params.id;
    const sql = "SELECT * FROM student_details WHERE `id`= ?";
    db.query(sql, [id], (err, result) => {
      if (err) res.json({ message: "Server error" });
      return res.json(result);
    });
  });


  app.post("/register", (req, res) => {
  
  const sql = "INSERT INTO users(`username`, `password`, `email`) VALUES (?)";
  bcrypt.hash(req.body.password.toString(), salt, (err, hash)=>{
  if (err) return res.json({Error: "Error for hashing password"});

  const values  = [
    req.body.name,
    hash,
    req.body.email
   
  ]
  db.query(sql, [values], (err)=>{
    if(err) return res.json({Error: "Insert failed"})
    return res.json({Status:"Success"})
  })
  })

   
  });

  app.post("/login", (req, res)=>{
    const sql ="SELECT * FROM users WHERE email= ?";
    db.query(sql, [req.body.email], (err, data)=>{
      if(err) return res.json({Error: "Login Failed"});
if(data.length>0){
bcrypt.compare(req.body.password.toString(), data[0].password, (err, response)=>{
  if(err) return res.json({Error: "password  hash error"});
  if(response){

 req.session.username = data[0].username;
 req.session.schoolcode = data[0].schoolcode;
 console.log(req.session.username);
 console.log(req.session.schoolcode);
  // const token = jwt.sign({username} , "jwt-secret-key", {expiresIn:'1d'})
  // res.cookie('token', token);
    res.json({Status:"Success"})
  }
  else{
    return res.json({Error: "password  mismatched"});
  }
})
}
else {
  return res.json({Error: "Email doest exist"})
}
    })
  })
 


  





  app.post("/create", (req, res) => {
    const sql = "INSERT INTO student_details (`schoolname`, `schoolcode`, `surname`, `firstname`, `middlename`, `residentialaddress`, `presentclass`, `yearadmitted`, `accountnumber`, `gender`,  `community_name`, `bank_name`, `nationality`, `guardian_contact`, `guardian_occupation`, `otherbank`, `otherbankaccount`, `class_at_admission`) VALUES(?)";
    const values = [
      
      req.body.value,
        req.body.valueSc,
        req.body.surname,
        req.body.firstname,  
        req.body.middlename,
        req.body.residentialaddress,
        req.body.presentclass,
        req.body.yearadmitted,
        req.body.accountno,
        req.body.selectedOption,
        req.body.communityname,
        req.body.bankselect,
        req.body.nationality,
        req.body.gcontact,
        req.body.goccupation,
        req.body.otherbank,
        req.body.otherbankaccount,
        req.body.classatadmission,


        

        
        
    ]
    db.query(sql, [values], (err, data) =>{
        if(err) return res.json("Error"+err);
        return res.json(data);
    })
})




app.delete("/del/:id", (req, res) => {

  const sql = "DELETE FROM student_details WHERE id = ?";
  const id = req.params.id;
  db.query(sql, [id], (err, result) => {
    if (err) return res.json({ Message: "Something unexpected has occured"});
    console.log(err);
    return res.json(result);
  });
});



app.put("/update/:id", (req, res) => {
    const sql = "UPDATE  students SET `studentname`=? , `email`=? WHERE id=?";
    const values = [
        req.body.name,
        req.body.email
    ]
    const id =req.params.id
    db.query(sql, [...values,id], (err, data) =>{
        if(err) return res.json("Error");
        return res.json(data);
    })
})



// app.delete("/logout", (req, res) => {
//  req.session.destroy();
//  return res.json({Status:"Success"})
// });
// router.delete('/logout', (req, res) => req.session.username.destroy())



app.listen(8082, ()=>{
    console.log("listening")
}) 